import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Label } from "@/components/ui/label";
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select";
import { 
  Phone, 
  Mail, 
  MapPin, 
  Clock, 
  Printer,
  Building2,
  MessageCircle
} from "lucide-react";

export default function ContactPage() {
  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-r from-blue-900/80 to-gray-900/80">
        <div className="absolute inset-0 bg-black/40"></div>
        <div className="absolute inset-0">
          <div className="w-full h-full bg-gradient-to-br from-blue-800 via-gray-800 to-slate-800"></div>
        </div>
        
        <div className="relative z-20 container mx-auto px-4 text-center text-white">
          <h1 className="text-4xl md:text-6xl font-bold mb-6">
            CONTACT US
          </h1>
          <p className="text-xl md:text-2xl max-w-3xl mx-auto">
            Get in Touch for Your Porta Cabin Solutions
          </p>
        </div>
      </section>

      {/* Contact Information & Form */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12">
            {/* Contact Information */}
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-8">Get in Touch</h2>
              
              <div className="space-y-6">
                {/* Main Office */}
                <Card className="p-6">
                  <CardHeader className="p-0 mb-4">
                    <CardTitle className="flex items-center space-x-3 text-xl">
                      <Building2 className="h-6 w-6 text-blue-600" />
                      <span>OUR MAIN OFFICE</span>
                    </CardTitle>
                  </CardHeader>
                  <CardContent className="p-0">
                    <div className="flex items-start space-x-3">
                      <MapPin className="h-5 w-5 text-blue-600 mt-1" />
                      <div>
                        <p className="text-gray-700 font-medium">P2 Hamriyah</p>
                        <p className="text-gray-600">Sharjah, UAE</p>
                        <p className="text-gray-600">Post Box: 662</p>
                      </div>
                    </div>
                  </CardContent>
                </Card>

                {/* Phone Numbers */}
                <Card className="p-6">
                  <CardHeader className="p-0 mb-4">
                    <CardTitle className="flex items-center space-x-3 text-xl">
                      <Phone className="h-6 w-6 text-green-600" />
                      <span>PHONE NUMBERS</span>
                    </CardTitle>
                  </CardHeader>
                  <CardContent className="p-0 space-y-3">
                    <div className="flex items-center space-x-3">
                      <MessageCircle className="h-5 w-5 text-green-600" />
                      <div>
                        <p className="text-gray-600 text-sm">DIRECT NUMBER</p>
                        <p className="text-gray-800 font-semibold">+971 58 201 2073</p>
                      </div>
                    </div>
                    <div className="flex items-center space-x-3">
                      <Phone className="h-5 w-5 text-blue-600" />
                      <div>
                        <p className="text-gray-600 text-sm">LAND LINE</p>
                        <p className="text-gray-800 font-semibold">+971 6 714 4832</p>
                      </div>
                    </div>
                    <div className="flex items-center space-x-3">
                      <Printer className="h-5 w-5 text-gray-600" />
                      <div>
                        <p className="text-gray-600 text-sm">FAX LINE</p>
                        <p className="text-gray-800 font-semibold">+971 6 714 4801</p>
                      </div>
                    </div>
                  </CardContent>
                </Card>

                {/* Email */}
                <Card className="p-6">
                  <CardHeader className="p-0 mb-4">
                    <CardTitle className="flex items-center space-x-3 text-xl">
                      <Mail className="h-6 w-6 text-orange-600" />
                      <span>EMAIL</span>
                    </CardTitle>
                  </CardHeader>
                  <CardContent className="p-0">
                    <a 
                      href="mailto:sales@saamcabins.com" 
                      className="text-blue-600 hover:text-blue-800 font-semibold text-lg"
                    >
                      sales@saamcabins.com
                    </a>
                  </CardContent>
                </Card>

                {/* Business Hours */}
                <Card className="p-6">
                  <CardHeader className="p-0 mb-4">
                    <CardTitle className="flex items-center space-x-3 text-xl">
                      <Clock className="h-6 w-6 text-purple-600" />
                      <span>BUSINESS HOURS</span>
                    </CardTitle>
                  </CardHeader>
                  <CardContent className="p-0">
                    <div className="space-y-2 text-gray-700">
                      <p><span className="font-medium">Monday - Friday:</span> 8:00 AM - 6:00 PM</p>
                      <p><span className="font-medium">Saturday:</span> 8:00 AM - 4:00 PM</p>
                      <p><span className="font-medium">Sunday:</span> Closed</p>
                      <p className="text-sm text-gray-600 mt-3">
                        Quick delivery available within few days across UAE
                      </p>
                    </div>
                  </CardContent>
                </Card>
              </div>
            </div>

            {/* Contact Form */}
            <div>
              <Card className="p-8">
                <CardHeader className="p-0 mb-6">
                  <CardTitle className="text-2xl font-bold text-gray-900">
                    Request a Quote
                  </CardTitle>
                  <CardDescription className="text-lg">
                    Fill out the form below and we'll get back to you with a customized quote for your porta cabin needs.
                  </CardDescription>
                </CardHeader>
                
                <CardContent className="p-0">
                  <form className="space-y-6">
                    <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                      <div>
                        <Label htmlFor="firstName">First Name *</Label>
                        <Input id="firstName" placeholder="Enter your first name" className="mt-1" />
                      </div>
                      <div>
                        <Label htmlFor="lastName">Last Name *</Label>
                        <Input id="lastName" placeholder="Enter your last name" className="mt-1" />
                      </div>
                    </div>
                    
                    <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                      <div>
                        <Label htmlFor="email">Email Address *</Label>
                        <Input id="email" type="email" placeholder="your.email@example.com" className="mt-1" />
                      </div>
                      <div>
                        <Label htmlFor="phone">Phone Number *</Label>
                        <Input id="phone" placeholder="+971 XX XXX XXXX" className="mt-1" />
                      </div>
                    </div>

                    <div>
                      <Label htmlFor="company">Company Name</Label>
                      <Input id="company" placeholder="Your company name (optional)" className="mt-1" />
                    </div>

                    <div>
                      <Label htmlFor="product">Product Type *</Label>
                      <Select>
                        <SelectTrigger className="mt-1">
                          <SelectValue placeholder="Select the type of cabin you need" />
                        </SelectTrigger>
                        <SelectContent>
                          <SelectItem value="office">Office Porta Cabin</SelectItem>
                          <SelectItem value="security">Security Cabin</SelectItem>
                          <SelectItem value="toilet">Toilet Units</SelectItem>
                          <SelectItem value="custom">Custom Solution</SelectItem>
                          <SelectItem value="multiple">Multiple Products</SelectItem>
                        </SelectContent>
                      </Select>
                    </div>

                    <div>
                      <Label htmlFor="quantity">Quantity Needed</Label>
                      <Input id="quantity" type="number" placeholder="How many units do you need?" className="mt-1" />
                    </div>

                    <div>
                      <Label htmlFor="location">Project Location</Label>
                      <Input id="location" placeholder="Where will the cabin be installed?" className="mt-1" />
                    </div>

                    <div>
                      <Label htmlFor="timeline">Required Timeline</Label>
                      <Select>
                        <SelectTrigger className="mt-1">
                          <SelectValue placeholder="When do you need this delivered?" />
                        </SelectTrigger>
                        <SelectContent>
                          <SelectItem value="urgent">Within 1 week</SelectItem>
                          <SelectItem value="normal">2-3 weeks</SelectItem>
                          <SelectItem value="flexible">1 month or more</SelectItem>
                          <SelectItem value="planning">Still planning</SelectItem>
                        </SelectContent>
                      </Select>
                    </div>

                    <div>
                      <Label htmlFor="message">Additional Requirements *</Label>
                      <Textarea 
                        id="message" 
                        placeholder="Please describe your specific requirements, dimensions, features needed, etc." 
                        rows={4}
                        className="mt-1"
                      />
                    </div>

                    <Button type="submit" className="w-full bg-blue-600 hover:bg-blue-700 text-lg py-6">
                      <Mail className="mr-2 h-5 w-5" />
                      Send Quote Request
                    </Button>
                  </form>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-blue-800 text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Want To Work With Us? Hit The Button.
          </h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            For immediate assistance, call us directly. Our team is ready to help with your porta cabin requirements.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button size="lg" className="bg-white text-blue-800 hover:bg-gray-100 px-8">
              <Phone className="mr-2 h-5 w-5" />
              Call Now: +971 58 201 2073
            </Button>
            <Button size="lg" variant="outline" className="border-white text-white hover:bg-white/10 px-8">
              <Mail className="mr-2 h-5 w-5" />
              Email: sales@saamcabins.com
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}